@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeContainerResponse.Companion.toKotlin as codeContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryCodeContainer].
 */
@PulumiTagMarker
public class RegistryCodeContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryCodeContainerArgs = RegistryCodeContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryCodeContainerArgsBuilder.() -> Unit) {
        val builder = RegistryCodeContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryCodeContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryCodeContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Code Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryCodeContainer = new AzureNative.MachineLearningServices.RegistryCodeContainer("registryCodeContainer", new()
 *     {
 *         CodeContainerProperties = new AzureNative.MachineLearningServices.Inputs.CodeContainerArgs
 *         {
 *             Description = "string",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         CodeName = "testContainer",
 *         RegistryName = "testregistry",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryCodeContainer(ctx, "registryCodeContainer", &machinelearningservices.RegistryCodeContainerArgs{
 * 			CodeContainerProperties: &machinelearningservices.CodeContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			CodeName:          pulumi.String("testContainer"),
 * 			RegistryName:      pulumi.String("testregistry"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.CodeContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryCodeContainer = new RegistryCodeContainer("registryCodeContainer", RegistryCodeContainerArgs.builder()
 *             .codeContainerProperties(CodeContainerArgs.builder()
 *                 .description("string")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .codeName("testContainer")
 *             .registryName("testregistry")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryCodeContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/codes/{codeName}
 * ```
 */
public class RegistryCodeContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer,
) : KotlinCustomResource(javaResource, RegistryCodeContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val codeContainerProperties: Output<CodeContainerResponse>
        get() = javaResource.codeContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                codeContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryCodeContainerMapper : ResourceMapper<RegistryCodeContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer::class == javaResource::class

    override fun map(javaResource: Resource): RegistryCodeContainer =
        RegistryCodeContainer(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer,
        )
}

/**
 * @see [RegistryCodeContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryCodeContainer].
 */
public suspend fun registryCodeContainer(
    name: String,
    block: suspend RegistryCodeContainerResourceBuilder.() -> Unit,
): RegistryCodeContainer {
    val builder = RegistryCodeContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryCodeContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryCodeContainer(name: String): RegistryCodeContainer {
    val builder = RegistryCodeContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
