@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeVersionResponse.Companion.toKotlin as codeVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryCodeVersion].
 */
@PulumiTagMarker
public class RegistryCodeVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryCodeVersionArgs = RegistryCodeVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryCodeVersionArgsBuilder.() -> Unit) {
        val builder = RegistryCodeVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryCodeVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryCodeVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Code Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryCodeVersion = new AzureNative.MachineLearningServices.RegistryCodeVersion("registryCodeVersion", new()
 *     {
 *         CodeName = "string",
 *         CodeVersionProperties = new AzureNative.MachineLearningServices.Inputs.CodeVersionArgs
 *         {
 *             CodeUri = "https://blobStorage/folderName",
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryCodeVersion(ctx, "registryCodeVersion", &machinelearningservices.RegistryCodeVersionArgs{
 * 			CodeName: pulumi.String("string"),
 * 			CodeVersionProperties: &machinelearningservices.CodeVersionTypeArgs{
 * 				CodeUri:     pulumi.String("https://blobStorage/folderName"),
 * 				Description: pulumi.String("string"),
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.CodeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryCodeVersion = new RegistryCodeVersion("registryCodeVersion", RegistryCodeVersionArgs.builder()
 *             .codeName("string")
 *             .codeVersionProperties(CodeVersionArgs.builder()
 *                 .codeUri("https://blobStorage/folderName")
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryCodeVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/codes/{codeName}/versions/{version}
 * ```
 */
public class RegistryCodeVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion,
) : KotlinCustomResource(javaResource, RegistryCodeVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val codeVersionProperties: Output<CodeVersionResponse>
        get() = javaResource.codeVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                codeVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryCodeVersionMapper : ResourceMapper<RegistryCodeVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion::class == javaResource::class

    override fun map(javaResource: Resource): RegistryCodeVersion = RegistryCodeVersion(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion,
    )
}

/**
 * @see [RegistryCodeVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryCodeVersion].
 */
public suspend fun registryCodeVersion(
    name: String,
    block: suspend RegistryCodeVersionResourceBuilder.() -> Unit,
): RegistryCodeVersion {
    val builder = RegistryCodeVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryCodeVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryCodeVersion(name: String): RegistryCodeVersion {
    val builder = RegistryCodeVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
