@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComponentVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComponentVersionResponse.Companion.toKotlin as componentVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryComponentVersion].
 */
@PulumiTagMarker
public class RegistryComponentVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryComponentVersionArgs = RegistryComponentVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryComponentVersionArgsBuilder.() -> Unit) {
        val builder = RegistryComponentVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryComponentVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryComponentVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Component Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryComponentVersion = new AzureNative.MachineLearningServices.RegistryComponentVersion("registryComponentVersion", new()
 *     {
 *         ComponentName = "string",
 *         ComponentVersionProperties = new AzureNative.MachineLearningServices.Inputs.ComponentVersionArgs
 *         {
 *             ComponentSpec = new Dictionary<string, object?>
 *             {
 *                 ["8ced901b-d826-477d-bfef-329da9672513"] = null,
 *             },
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryComponentVersion(ctx, "registryComponentVersion", &machinelearningservices.RegistryComponentVersionArgs{
 * 			ComponentName: pulumi.String("string"),
 * 			ComponentVersionProperties: &machinelearningservices.ComponentVersionTypeArgs{
 * 				ComponentSpec: pulumi.Any(map[string]interface{}{
 * 					"8ced901b-d826-477d-bfef-329da9672513": nil,
 * 				}),
 * 				Description: pulumi.String("string"),
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryComponentVersion = new RegistryComponentVersion("registryComponentVersion", RegistryComponentVersionArgs.builder()
 *             .componentName("string")
 *             .componentVersionProperties(ComponentVersionArgs.builder()
 *                 .componentSpec(Map.of("8ced901b-d826-477d-bfef-329da9672513", null))
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryComponentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/components/{componentName}/versions/{version}
 * ```
 */
public class RegistryComponentVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion,
) : KotlinCustomResource(javaResource, RegistryComponentVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val componentVersionProperties: Output<ComponentVersionResponse>
        get() = javaResource.componentVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                componentVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryComponentVersionMapper : ResourceMapper<RegistryComponentVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion::class == javaResource::class

    override fun map(javaResource: Resource): RegistryComponentVersion =
        RegistryComponentVersion(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion,
        )
}

/**
 * @see [RegistryComponentVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryComponentVersion].
 */
public suspend fun registryComponentVersion(
    name: String,
    block: suspend RegistryComponentVersionResourceBuilder.() -> Unit,
): RegistryComponentVersion {
    val builder = RegistryComponentVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryComponentVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryComponentVersion(name: String): RegistryComponentVersion {
    val builder = RegistryComponentVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
