@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DataContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DataContainerResponse.Companion.toKotlin as dataContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryDataContainer].
 */
@PulumiTagMarker
public class RegistryDataContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryDataContainerArgs = RegistryDataContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryDataContainerArgsBuilder.() -> Unit) {
        val builder = RegistryDataContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryDataContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryDataContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryDataContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Data Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryDataContainer = new AzureNative.MachineLearningServices.RegistryDataContainer("registryDataContainer", new()
 *     {
 *         DataContainerProperties = new AzureNative.MachineLearningServices.Inputs.DataContainerArgs
 *         {
 *             DataType = AzureNative.MachineLearningServices.DataType.Uri_folder,
 *             Description = "string",
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         RegistryName = "registryName",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryDataContainer(ctx, "registryDataContainer", &machinelearningservices.RegistryDataContainerArgs{
 * 			DataContainerProperties: &machinelearningservices.DataContainerTypeArgs{
 * 				DataType:    pulumi.String(machinelearningservices.DataType_Uri_folder),
 * 				Description: pulumi.String("string"),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			RegistryName:      pulumi.String("registryName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryDataContainer = new RegistryDataContainer("registryDataContainer", RegistryDataContainerArgs.builder()
 *             .dataContainerProperties(DataContainerArgs.builder()
 *                 .dataType("uri_folder")
 *                 .description("string")
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .registryName("registryName")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryDataContainer string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/data/{name}
 * ```
 */
public class RegistryDataContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryDataContainer,
) : KotlinCustomResource(javaResource, RegistryDataContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val dataContainerProperties: Output<DataContainerResponse>
        get() = javaResource.dataContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                dataContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryDataContainerMapper : ResourceMapper<RegistryDataContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryDataContainer::class == javaResource::class

    override fun map(javaResource: Resource): RegistryDataContainer =
        RegistryDataContainer(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryDataContainer,
        )
}

/**
 * @see [RegistryDataContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryDataContainer].
 */
public suspend fun registryDataContainer(
    name: String,
    block: suspend RegistryDataContainerResourceBuilder.() -> Unit,
): RegistryDataContainer {
    val builder = RegistryDataContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryDataContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryDataContainer(name: String): RegistryDataContainer {
    val builder = RegistryDataContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
