@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryDataVersion].
 */
@PulumiTagMarker
public class RegistryDataVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryDataVersionArgs = RegistryDataVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryDataVersionArgsBuilder.() -> Unit) {
        val builder = RegistryDataVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryDataVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryDataVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryDataVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Data Version Base.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryDataVersion = new AzureNative.MachineLearningServices.RegistryDataVersion("registryDataVersion", new()
 *     {
 *         DataVersionBaseProperties = new AzureNative.MachineLearningServices.Inputs.MLTableDataArgs
 *         {
 *             DataType = "mltable",
 *             DataUri = "string",
 *             Description = "string",
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             ReferencedUris = new[]
 *             {
 *                 "string",
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         RegistryName = "registryName",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryDataVersion(ctx, "registryDataVersion", &machinelearningservices.RegistryDataVersionArgs{
 * 			DataVersionBaseProperties: machinelearningservices.MLTableData{
 * 				DataType:    "mltable",
 * 				DataUri:     "string",
 * 				Description: "string",
 * 				IsAnonymous: false,
 * 				IsArchived:  false,
 * 				Properties: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 				ReferencedUris: []string{
 * 					"string",
 * 				},
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			RegistryName:      pulumi.String("registryName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryDataVersion = new RegistryDataVersion("registryDataVersion", RegistryDataVersionArgs.builder()
 *             .dataVersionBaseProperties(MLTableDataArgs.builder()
 *                 .dataType("mltable")
 *                 .dataUri("string")
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .referencedUris("string")
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .registryName("registryName")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryDataVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/data/{name}/versions/{version}
 * ```
 */
public class RegistryDataVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryDataVersion,
) : KotlinCustomResource(javaResource, RegistryDataVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val dataVersionBaseProperties: Output<Any>
        get() = javaResource.dataVersionBaseProperties().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryDataVersionMapper : ResourceMapper<RegistryDataVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryDataVersion::class == javaResource::class

    override fun map(javaResource: Resource): RegistryDataVersion = RegistryDataVersion(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.RegistryDataVersion,
    )
}

/**
 * @see [RegistryDataVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryDataVersion].
 */
public suspend fun registryDataVersion(
    name: String,
    block: suspend RegistryDataVersionResourceBuilder.() -> Unit,
): RegistryDataVersion {
    val builder = RegistryDataVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryDataVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryDataVersion(name: String): RegistryDataVersion {
    val builder = RegistryDataVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
