@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Data Version Base.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryDataVersion = new AzureNative.MachineLearningServices.RegistryDataVersion("registryDataVersion", new()
 *     {
 *         DataVersionBaseProperties = new AzureNative.MachineLearningServices.Inputs.MLTableDataArgs
 *         {
 *             DataType = "mltable",
 *             DataUri = "string",
 *             Description = "string",
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             ReferencedUris = new[]
 *             {
 *                 "string",
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         RegistryName = "registryName",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryDataVersion(ctx, "registryDataVersion", &machinelearningservices.RegistryDataVersionArgs{
 * 			DataVersionBaseProperties: machinelearningservices.MLTableData{
 * 				DataType:    "mltable",
 * 				DataUri:     "string",
 * 				Description: "string",
 * 				IsAnonymous: false,
 * 				IsArchived:  false,
 * 				Properties: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 				ReferencedUris: []string{
 * 					"string",
 * 				},
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			RegistryName:      pulumi.String("registryName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryDataVersion = new RegistryDataVersion("registryDataVersion", RegistryDataVersionArgs.builder()
 *             .dataVersionBaseProperties(MLTableDataArgs.builder()
 *                 .dataType("mltable")
 *                 .dataUri("string")
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .referencedUris("string")
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .registryName("registryName")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryDataVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/data/{name}/versions/{version}
 * ```
 * @property dataVersionBaseProperties [Required] Additional attributes of the entity.
 * @property name Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class RegistryDataVersionArgs(
    public val dataVersionBaseProperties: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryDataVersionArgs.builder()
            .dataVersionBaseProperties(dataVersionBaseProperties?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryDataVersionArgs].
 */
@PulumiTagMarker
public class RegistryDataVersionArgsBuilder internal constructor() {
    private var dataVersionBaseProperties: Output<Any>? = null

    private var name: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("bkxvgmsyukrlfxgn")
    public suspend fun dataVersionBaseProperties(`value`: Output<Any>) {
        this.dataVersionBaseProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("rjrtvmkuucoghusw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("recckwiivqvpxydx")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bwtwtqssfgxrjgbi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("dklbnikkepcexmot")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("buumcxlwlgprjtiy")
    public suspend fun dataVersionBaseProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataVersionBaseProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("kylcneksvqmjwvud")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("mnjwhiyhywjynxrw")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("txoqpcxkiatqlbfr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("ytdlfvveuaqhroci")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RegistryDataVersionArgs = RegistryDataVersionArgs(
        dataVersionBaseProperties = dataVersionBaseProperties,
        name = name,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
