@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Environment Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryEnvironmentContainer = new AzureNative.MachineLearningServices.RegistryEnvironmentContainer("registryEnvironmentContainer", new()
 *     {
 *         EnvironmentContainerProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         EnvironmentName = "testEnvironment",
 *         RegistryName = "testregistry",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryEnvironmentContainer(ctx, "registryEnvironmentContainer", &machinelearningservices.RegistryEnvironmentContainerArgs{
 * 			EnvironmentContainerProperties: &machinelearningservices.EnvironmentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("testEnvironment"),
 * 			RegistryName:      pulumi.String("testregistry"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryEnvironmentContainer = new RegistryEnvironmentContainer("registryEnvironmentContainer", RegistryEnvironmentContainerArgs.builder()
 *             .environmentContainerProperties(EnvironmentContainerArgs.builder()
 *                 .description("string")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .tags(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .build())
 *             .environmentName("testEnvironment")
 *             .registryName("testregistry")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryEnvironmentContainer testEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}
 * ```
 * @property environmentContainerProperties [Required] Additional attributes of the entity.
 * @property environmentName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class RegistryEnvironmentContainerArgs(
    public val environmentContainerProperties: Output<EnvironmentContainerArgs>? = null,
    public val environmentName: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs.builder()
            .environmentContainerProperties(
                environmentContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryEnvironmentContainerArgs].
 */
@PulumiTagMarker
public class RegistryEnvironmentContainerArgsBuilder internal constructor() {
    private var environmentContainerProperties: Output<EnvironmentContainerArgs>? = null

    private var environmentName: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("bnidovjiranmoytq")
    public suspend fun environmentContainerProperties(`value`: Output<EnvironmentContainerArgs>) {
        this.environmentContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("bumjwxyifqanbgag")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("ospbbtuiprihlcnq")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tryrjcnegmolcwtx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("reqtmcfhdqggdaut")
    public suspend fun environmentContainerProperties(`value`: EnvironmentContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("quvxfjyidpikehaf")
    public suspend fun environmentContainerProperties(argument: suspend EnvironmentContainerArgsBuilder.() -> Unit) {
        val toBeMapped = EnvironmentContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environmentContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("wgowtxunrwoaotiv")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("hpgrowaprgtkykiq")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uarcacggwkxaosnd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegistryEnvironmentContainerArgs = RegistryEnvironmentContainerArgs(
        environmentContainerProperties = environmentContainerProperties,
        environmentName = environmentName,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
