@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelContainerResponse.Companion.toKotlin as modelContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryModelContainer].
 */
@PulumiTagMarker
public class RegistryModelContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryModelContainerArgs = RegistryModelContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryModelContainerArgsBuilder.() -> Unit) {
        val builder = RegistryModelContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryModelContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryModelContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryModelContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Model Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryModelContainer = new AzureNative.MachineLearningServices.RegistryModelContainer("registryModelContainer", new()
 *     {
 *         ModelContainerProperties = new AzureNative.MachineLearningServices.Inputs.ModelContainerArgs
 *         {
 *             Description = "Model container description",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         ModelName = "testContainer",
 *         RegistryName = "registry123",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryModelContainer(ctx, "registryModelContainer", &machinelearningservices.RegistryModelContainerArgs{
 * 			ModelContainerProperties: &machinelearningservices.ModelContainerTypeArgs{
 * 				Description: pulumi.String("Model container description"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			ModelName:         pulumi.String("testContainer"),
 * 			RegistryName:      pulumi.String("registry123"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.ModelContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryModelContainer = new RegistryModelContainer("registryModelContainer", RegistryModelContainerArgs.builder()
 *             .modelContainerProperties(ModelContainerArgs.builder()
 *                 .description("Model container description")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .modelName("testContainer")
 *             .registryName("registry123")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryModelContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/models/{modelName}
 * ```
 */
public class RegistryModelContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryModelContainer,
) : KotlinCustomResource(javaResource, RegistryModelContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val modelContainerProperties: Output<ModelContainerResponse>
        get() = javaResource.modelContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                modelContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryModelContainerMapper : ResourceMapper<RegistryModelContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryModelContainer::class == javaResource::class

    override fun map(javaResource: Resource): RegistryModelContainer =
        RegistryModelContainer(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryModelContainer,
        )
}

/**
 * @see [RegistryModelContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryModelContainer].
 */
public suspend fun registryModelContainer(
    name: String,
    block: suspend RegistryModelContainerResourceBuilder.() -> Unit,
): RegistryModelContainer {
    val builder = RegistryModelContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryModelContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryModelContainer(name: String): RegistryModelContainer {
    val builder = RegistryModelContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
