@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelVersionResponse.Companion.toKotlin as modelVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryModelVersion].
 */
@PulumiTagMarker
public class RegistryModelVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryModelVersionArgs = RegistryModelVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryModelVersionArgsBuilder.() -> Unit) {
        val builder = RegistryModelVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryModelVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryModelVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryModelVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Model Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryModelVersion = new AzureNative.MachineLearningServices.RegistryModelVersion("registryModelVersion", new()
 *     {
 *         ModelName = "string",
 *         ModelVersionProperties = new AzureNative.MachineLearningServices.Inputs.ModelVersionArgs
 *         {
 *             Description = "string",
 *             Flavors =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.FlavorDataArgs
 *                 {
 *                     Data =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             IsAnonymous = false,
 *             ModelType = "CustomModel",
 *             ModelUri = "string",
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryModelVersion(ctx, "registryModelVersion", &machinelearningservices.RegistryModelVersionArgs{
 * 			ModelName: pulumi.String("string"),
 * 			ModelVersionProperties: &machinelearningservices.ModelVersionTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Flavors: machinelearningservices.FlavorDataMap{
 * 					"string": &machinelearningservices.FlavorDataArgs{
 * 						Data: pulumi.StringMap{
 * 							"string": pulumi.String("string"),
 * 						},
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				ModelType:   pulumi.String("CustomModel"),
 * 				ModelUri:    pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.ModelVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryModelVersion = new RegistryModelVersion("registryModelVersion", RegistryModelVersionArgs.builder()
 *             .modelName("string")
 *             .modelVersionProperties(ModelVersionArgs.builder()
 *                 .description("string")
 *                 .flavors(Map.of("string", Map.of("data", Map.of("string", "string"))))
 *                 .isAnonymous(false)
 *                 .modelType("CustomModel")
 *                 .modelUri("string")
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryModelVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/models/{modelName}/versions/{version}
 * ```
 */
public class RegistryModelVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.RegistryModelVersion,
) : KotlinCustomResource(javaResource, RegistryModelVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val modelVersionProperties: Output<ModelVersionResponse>
        get() = javaResource.modelVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                modelVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryModelVersionMapper : ResourceMapper<RegistryModelVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryModelVersion::class == javaResource::class

    override fun map(javaResource: Resource): RegistryModelVersion = RegistryModelVersion(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.RegistryModelVersion,
    )
}

/**
 * @see [RegistryModelVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryModelVersion].
 */
public suspend fun registryModelVersion(
    name: String,
    block: suspend RegistryModelVersionResourceBuilder.() -> Unit,
): RegistryModelVersion {
    val builder = RegistryModelVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryModelVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryModelVersion(name: String): RegistryModelVersion {
    val builder = RegistryModelVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
