@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.WorkspaceArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EncryptionPropertyArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EncryptionPropertyArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ServiceManagedResourcesSettingsArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ServiceManagedResourcesSettingsArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SharedPrivateLinkResourceArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SharedPrivateLinkResourceArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a machine learning workspace.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2018-03-01-preview, 2020-08-01, 2020-09-01-preview, 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Workspace testworkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}
 * ```
 * @property allowPublicAccessWhenBehindVnet The flag to indicate whether to allow public access when behind VNet.
 * @property applicationInsights ARM id of the application insights associated with this workspace.
 * @property containerRegistry ARM id of the container registry associated with this workspace.
 * @property description The description of this workspace.
 * @property discoveryUrl Url for the discovery service to identify regional endpoints for machine learning experimentation services
 * @property encryption The encryption settings of Azure ML workspace.
 * @property friendlyName The friendly name for this workspace. This name in mutable
 * @property hbiWorkspace The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
 * @property identity The identity of the resource.
 * @property imageBuildCompute The compute name for image build
 * @property keyVault ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
 * @property location Specifies the location of the resource.
 * @property primaryUserAssignedIdentity The user assigned identity resource id that represents the workspace identity.
 * @property publicNetworkAccess Whether requests from Public Network are allowed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceManagedResourcesSettings The service managed resource settings.
 * @property sharedPrivateLinkResources The list of shared private link resources in this workspace.
 * @property sku The sku of the workspace.
 * @property storageAccount ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
 * @property tags Contains resource tags defined as key/value pairs.
 * @property v1LegacyMode Enabling v1_legacy_mode may prevent you from using features provided by the v2 API.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class WorkspaceArgs(
    public val allowPublicAccessWhenBehindVnet: Output<Boolean>? = null,
    public val applicationInsights: Output<String>? = null,
    public val containerRegistry: Output<String>? = null,
    public val description: Output<String>? = null,
    public val discoveryUrl: Output<String>? = null,
    public val encryption: Output<EncryptionPropertyArgs>? = null,
    public val friendlyName: Output<String>? = null,
    public val hbiWorkspace: Output<Boolean>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val imageBuildCompute: Output<String>? = null,
    public val keyVault: Output<String>? = null,
    public val location: Output<String>? = null,
    public val primaryUserAssignedIdentity: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceManagedResourcesSettings: Output<ServiceManagedResourcesSettingsArgs>? = null,
    public val sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceArgs>>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val storageAccount: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val v1LegacyMode: Output<Boolean>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.WorkspaceArgs =
        com.pulumi.azurenative.machinelearningservices.WorkspaceArgs.builder()
            .allowPublicAccessWhenBehindVnet(allowPublicAccessWhenBehindVnet?.applyValue({ args0 -> args0 }))
            .applicationInsights(applicationInsights?.applyValue({ args0 -> args0 }))
            .containerRegistry(containerRegistry?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .discoveryUrl(discoveryUrl?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hbiWorkspace(hbiWorkspace?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageBuildCompute(imageBuildCompute?.applyValue({ args0 -> args0 }))
            .keyVault(keyVault?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .primaryUserAssignedIdentity(primaryUserAssignedIdentity?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceManagedResourcesSettings(
                serviceManagedResourcesSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sharedPrivateLinkResources(
                sharedPrivateLinkResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .v1LegacyMode(v1LegacyMode?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var allowPublicAccessWhenBehindVnet: Output<Boolean>? = null

    private var applicationInsights: Output<String>? = null

    private var containerRegistry: Output<String>? = null

    private var description: Output<String>? = null

    private var discoveryUrl: Output<String>? = null

    private var encryption: Output<EncryptionPropertyArgs>? = null

    private var friendlyName: Output<String>? = null

    private var hbiWorkspace: Output<Boolean>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var imageBuildCompute: Output<String>? = null

    private var keyVault: Output<String>? = null

    private var location: Output<String>? = null

    private var primaryUserAssignedIdentity: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceManagedResourcesSettings: Output<ServiceManagedResourcesSettingsArgs>? = null

    private var sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceArgs>>? = null

    private var sku: Output<SkuArgs>? = null

    private var storageAccount: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var v1LegacyMode: Output<Boolean>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The flag to indicate whether to allow public access when behind VNet.
     */
    @JvmName("yeojcfplxaxujdwb")
    public suspend fun allowPublicAccessWhenBehindVnet(`value`: Output<Boolean>) {
        this.allowPublicAccessWhenBehindVnet = value
    }

    /**
     * @param value ARM id of the application insights associated with this workspace.
     */
    @JvmName("gfsxuaxkcsrlwgok")
    public suspend fun applicationInsights(`value`: Output<String>) {
        this.applicationInsights = value
    }

    /**
     * @param value ARM id of the container registry associated with this workspace.
     */
    @JvmName("xglefgyfgbdfqjlj")
    public suspend fun containerRegistry(`value`: Output<String>) {
        this.containerRegistry = value
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("wbjkioinfgifyrvh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Url for the discovery service to identify regional endpoints for machine learning experimentation services
     */
    @JvmName("vymsfxxqcvjcmtig")
    public suspend fun discoveryUrl(`value`: Output<String>) {
        this.discoveryUrl = value
    }

    /**
     * @param value The encryption settings of Azure ML workspace.
     */
    @JvmName("hxebkfmnrrkdtkff")
    public suspend fun encryption(`value`: Output<EncryptionPropertyArgs>) {
        this.encryption = value
    }

    /**
     * @param value The friendly name for this workspace. This name in mutable
     */
    @JvmName("icmvunygekwleifh")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
     */
    @JvmName("rdfyjeeovxryqjoj")
    public suspend fun hbiWorkspace(`value`: Output<Boolean>) {
        this.hbiWorkspace = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("rdhleftqjjbddukg")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The compute name for image build
     */
    @JvmName("qpbauaberxrcfpoo")
    public suspend fun imageBuildCompute(`value`: Output<String>) {
        this.imageBuildCompute = value
    }

    /**
     * @param value ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
     */
    @JvmName("cetxdlspnskdfbom")
    public suspend fun keyVault(`value`: Output<String>) {
        this.keyVault = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("sbuyanewvxkxhlmd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The user assigned identity resource id that represents the workspace identity.
     */
    @JvmName("ngvryehjcijvyjpr")
    public suspend fun primaryUserAssignedIdentity(`value`: Output<String>) {
        this.primaryUserAssignedIdentity = value
    }

    /**
     * @param value Whether requests from Public Network are allowed.
     */
    @JvmName("hlqmyecrvyylerpu")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("legytvtprvnayucb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The service managed resource settings.
     */
    @JvmName("iqfwrmglgfcwuwmj")
    public suspend fun serviceManagedResourcesSettings(`value`: Output<ServiceManagedResourcesSettingsArgs>) {
        this.serviceManagedResourcesSettings = value
    }

    /**
     * @param value The list of shared private link resources in this workspace.
     */
    @JvmName("jglqkqfmybvxuwla")
    public suspend fun sharedPrivateLinkResources(`value`: Output<List<SharedPrivateLinkResourceArgs>>) {
        this.sharedPrivateLinkResources = value
    }

    @JvmName("jjgdxmjxvudbivap")
    public suspend fun sharedPrivateLinkResources(vararg values: Output<SharedPrivateLinkResourceArgs>) {
        this.sharedPrivateLinkResources = Output.all(values.asList())
    }

    /**
     * @param values The list of shared private link resources in this workspace.
     */
    @JvmName("rlbgshofnotathia")
    public suspend fun sharedPrivateLinkResources(values: List<Output<SharedPrivateLinkResourceArgs>>) {
        this.sharedPrivateLinkResources = Output.all(values)
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("ohoxfugitltipbrt")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
     */
    @JvmName("alowagnwfwsvxgnk")
    public suspend fun storageAccount(`value`: Output<String>) {
        this.storageAccount = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("gwbvwjfdvsqwqtfq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enabling v1_legacy_mode may prevent you from using features provided by the v2 API.
     */
    @JvmName("gejtjswcskbydeua")
    public suspend fun v1LegacyMode(`value`: Output<Boolean>) {
        this.v1LegacyMode = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("uqbeondwaoqeslua")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The flag to indicate whether to allow public access when behind VNet.
     */
    @JvmName("hkbvrecsnkfebgio")
    public suspend fun allowPublicAccessWhenBehindVnet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowPublicAccessWhenBehindVnet = mapped
    }

    /**
     * @param value ARM id of the application insights associated with this workspace.
     */
    @JvmName("fsypxkfiuaujmhxo")
    public suspend fun applicationInsights(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationInsights = mapped
    }

    /**
     * @param value ARM id of the container registry associated with this workspace.
     */
    @JvmName("swnestvdpstvsgob")
    public suspend fun containerRegistry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistry = mapped
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("mqjlvirdgktpfmmu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Url for the discovery service to identify regional endpoints for machine learning experimentation services
     */
    @JvmName("hxaqbykefbqycduy")
    public suspend fun discoveryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryUrl = mapped
    }

    /**
     * @param value The encryption settings of Azure ML workspace.
     */
    @JvmName("mypouaalxvredemp")
    public suspend fun encryption(`value`: EncryptionPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption settings of Azure ML workspace.
     */
    @JvmName("ggadnexnigvweamm")
    public suspend fun encryption(argument: suspend EncryptionPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The friendly name for this workspace. This name in mutable
     */
    @JvmName("gbiyccluwashniki")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
     */
    @JvmName("aubmrcuvsyawgala")
    public suspend fun hbiWorkspace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hbiWorkspace = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("jtuegwccufujboiq")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("uhctsjnujysddcmy")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The compute name for image build
     */
    @JvmName("mquocxxylboypshe")
    public suspend fun imageBuildCompute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageBuildCompute = mapped
    }

    /**
     * @param value ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
     */
    @JvmName("omphhvclnopwpwrp")
    public suspend fun keyVault(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("fjolsjxyyofpjwbc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The user assigned identity resource id that represents the workspace identity.
     */
    @JvmName("ctotexlpitngxxcp")
    public suspend fun primaryUserAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryUserAssignedIdentity = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed.
     */
    @JvmName("jydlcgsmpmfewkcw")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed.
     */
    @JvmName("qdjprywonckwtpcq")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed.
     */
    @JvmName("bjnjvvlcdurmeggp")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("todscpsmyratccir")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The service managed resource settings.
     */
    @JvmName("jmrykrwdiqebmtci")
    public suspend fun serviceManagedResourcesSettings(`value`: ServiceManagedResourcesSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceManagedResourcesSettings = mapped
    }

    /**
     * @param argument The service managed resource settings.
     */
    @JvmName("dtwsjsiaxrobogse")
    public suspend fun serviceManagedResourcesSettings(argument: suspend ServiceManagedResourcesSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceManagedResourcesSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceManagedResourcesSettings = mapped
    }

    /**
     * @param value The list of shared private link resources in this workspace.
     */
    @JvmName("qadbsnohwdtaqmau")
    public suspend fun sharedPrivateLinkResources(`value`: List<SharedPrivateLinkResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResources = mapped
    }

    /**
     * @param argument The list of shared private link resources in this workspace.
     */
    @JvmName("lguiylobonvaksos")
    public suspend fun sharedPrivateLinkResources(argument: List<suspend SharedPrivateLinkResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SharedPrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sharedPrivateLinkResources = mapped
    }

    /**
     * @param argument The list of shared private link resources in this workspace.
     */
    @JvmName("ityxgmkwlurslhmu")
    public suspend fun sharedPrivateLinkResources(vararg argument: suspend SharedPrivateLinkResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SharedPrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sharedPrivateLinkResources = mapped
    }

    /**
     * @param argument The list of shared private link resources in this workspace.
     */
    @JvmName("bfcamjgdocfkbjas")
    public suspend fun sharedPrivateLinkResources(argument: suspend SharedPrivateLinkResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SharedPrivateLinkResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sharedPrivateLinkResources = mapped
    }

    /**
     * @param values The list of shared private link resources in this workspace.
     */
    @JvmName("mctubpmfbaguehrw")
    public suspend fun sharedPrivateLinkResources(vararg values: SharedPrivateLinkResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResources = mapped
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("tkbuhugmkljwuoft")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of the workspace.
     */
    @JvmName("bnckanbethpoeamq")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
     */
    @JvmName("aveomfuvjiwtipqv")
    public suspend fun storageAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("mwfjghryoqnxecqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("xhmvkbnojryrvheg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Enabling v1_legacy_mode may prevent you from using features provided by the v2 API.
     */
    @JvmName("fjbmjemfdjywscsm")
    public suspend fun v1LegacyMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.v1LegacyMode = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("iyjthikqdpgwalog")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        allowPublicAccessWhenBehindVnet = allowPublicAccessWhenBehindVnet,
        applicationInsights = applicationInsights,
        containerRegistry = containerRegistry,
        description = description,
        discoveryUrl = discoveryUrl,
        encryption = encryption,
        friendlyName = friendlyName,
        hbiWorkspace = hbiWorkspace,
        identity = identity,
        imageBuildCompute = imageBuildCompute,
        keyVault = keyVault,
        location = location,
        primaryUserAssignedIdentity = primaryUserAssignedIdentity,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        serviceManagedResourcesSettings = serviceManagedResourcesSettings,
        sharedPrivateLinkResources = sharedPrivateLinkResources,
        sku = sku,
        storageAccount = storageAccount,
        tags = tags,
        v1LegacyMode = v1LegacyMode,
        workspaceName = workspaceName,
    )
}
