@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2021-04-01, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview, 2024-04-01, 2024-04-01-preview.
 * ## Example Usage
 * ### CreateWorkspaceConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceConnection = new AzureNative.MachineLearningServices.WorkspaceConnection("workspaceConnection", new()
 *     {
 *         ConnectionName = "connection-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.NoneAuthTypeWorkspaceConnectionPropertiesArgs
 *         {
 *             AuthType = "None",
 *             Category = AzureNative.MachineLearningServices.ConnectionCategory.ContainerRegistry,
 *             Target = "www.facebook.com",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewWorkspaceConnection(ctx, "workspaceConnection", &machinelearningservices.WorkspaceConnectionArgs{
 * 			ConnectionName: pulumi.String("connection-1"),
 * 			Properties: machinelearningservices.NoneAuthTypeWorkspaceConnectionProperties{
 * 				AuthType: "None",
 * 				Category: machinelearningservices.ConnectionCategoryContainerRegistry,
 * 				Target:   "www.facebook.com",
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.WorkspaceConnection;
 * import com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceConnection = new WorkspaceConnection("workspaceConnection", WorkspaceConnectionArgs.builder()
 *             .connectionName("connection-1")
 *             .properties(NoneAuthTypeWorkspaceConnectionPropertiesArgs.builder()
 *                 .authType("None")
 *                 .category("ContainerRegistry")
 *                 .target("www.facebook.com")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:WorkspaceConnection connection-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}
 * ```
 * @property connectionName Friendly name of the workspace connection
 * @property properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class WorkspaceConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs =
        com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceConnectionArgs].
 */
@PulumiTagMarker
public class WorkspaceConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("wrisvxabcwvgajwv")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value
     */
    @JvmName("tdybakqmhtcblhhf")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwkioitbdudtocgp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("jprhmsvjstmihbsj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("oumbfbfrrbdirnpm")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qpegjywlkplovipf")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ujwxcmtnbwlqrsbn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("onasqfnkbanrbvci")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceConnectionArgs = WorkspaceConnectionArgs(
        connectionName = connectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
