@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
 */
public enum class ApplicationSharingPolicy(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy> {
    Personal(com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy.Personal),
    Shared(com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy.Shared),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ApplicationSharingPolicy): ApplicationSharingPolicy =
            ApplicationSharingPolicy.values().first { it.javaValue == javaType }
    }
}
