@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Connection status of the service consumer with the service provider
 */
public enum class EndpointServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus> {
    Approved(com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus.Approved),
    Pending(com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus.Pending),
    Rejected(com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.EndpointServiceConnectionStatus): EndpointServiceConnectionStatus =
            EndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
