@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
 */
public enum class ImageType(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.ImageType,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ImageType> {
    Docker(com.pulumi.azurenative.machinelearningservices.enums.ImageType.Docker),
    Azureml(com.pulumi.azurenative.machinelearningservices.enums.ImageType.Azureml),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.ImageType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ImageType): ImageType = ImageType.values().first { it.javaValue == javaType }
    }
}
