@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
 * Note: training run may get into CUDA OOM if the model size is too big.
 * Note: This settings is only supported for the 'yolov5' algorithm.
 */
public enum class ModelSize(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.ModelSize,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ModelSize> {
    /**
     * No value selected.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.ModelSize.None),

    /**
     * Small size.
     */
    Small(com.pulumi.azurenative.machinelearningservices.enums.ModelSize.Small),

    /**
     * Medium size.
     */
    Medium(com.pulumi.azurenative.machinelearningservices.enums.ModelSize.Medium),

    /**
     * Large size.
     */
    Large(com.pulumi.azurenative.machinelearningservices.enums.ModelSize.Large),

    /**
     * Extra large size.
     */
    ExtraLarge(com.pulumi.azurenative.machinelearningservices.enums.ModelSize.ExtraLarge),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.ModelSize = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ModelSize): ModelSize = ModelSize.values().first { it.javaValue == javaType }
    }
}
