@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus.Disconnected),
    Timeout(com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus.Timeout),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.PrivateEndpointServiceConnectionStatus): PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
