@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum for all Regression models supported by AutoML.
 */
public enum class RegressionModels(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.RegressionModels,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.RegressionModels> {
    /**
     * Elastic net is a popular type of regularized linear regression that combines two popular penalties, specifically the L1 and L2 penalty functions.
     */
    ElasticNet(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.ElasticNet),

    /**
     * The technique of transiting week learners into a strong learner is called Boosting. The gradient boosting algorithm process works on this theory of execution.
     */
    GradientBoosting(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.GradientBoosting),

    /**
     * Decision Trees are a non-parametric supervised learning method used for both classification and regression tasks.
     * The goal is to create a model that predicts the value of a target variable by learning simple decision rules inferred from the data features.
     */
    DecisionTree(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.DecisionTree),

    /**
     * K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new datapoints
     * which further means that the new data point will be assigned a value based on how closely it matches the points in the training set.
     */
    KNN(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.KNN),

    /**
     * Lasso model fit with Least Angle Regression a.k.a. Lars. It is a Linear Model trained with an L1 prior as regularizer.
     */
    LassoLars(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.LassoLars),

    /**
     * SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning applications
     * to find the model parameters that correspond to the best fit between predicted and actual outputs.
     * It's an inexact but powerful technique.
     */
    SGD(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.SGD),

    /**
     * Random forest is a supervised learning algorithm.
     * The "forest" it builds, is an ensemble of decision trees, usually trained with the “bagging” method.
     * The general idea of the bagging method is that a combination of learning models increases the overall result.
     */
    RandomForest(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.RandomForest),

    /**
     * Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many decision trees. It is related to the widely used random forest algorithm.
     */
    ExtremeRandomTrees(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.ExtremeRandomTrees),

    /**
     * LightGBM is a gradient boosting framework that uses tree based learning algorithms.
     */
    LightGBM(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.LightGBM),

    /**
     * XGBoostRegressor: Extreme Gradient Boosting Regressor is a supervised machine learning model using ensemble of base learners.
     */
    XGBoostRegressor(com.pulumi.azurenative.machinelearningservices.enums.RegressionModels.XGBoostRegressor),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.RegressionModels =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.RegressionModels): RegressionModels = RegressionModels.values().first { it.javaValue == javaType }
    }
}
