@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Primary metric for regression task.
 */
public enum class RegressionPrimaryMetrics(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics> {
    /**
     * The Spearman's rank coefficient of correlation is a nonparametric measure of rank correlation.
     */
    SpearmanCorrelation(com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics.SpearmanCorrelation),

    /**
     * The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between models with different scales.
     */
    NormalizedRootMeanSquaredError(com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics.NormalizedRootMeanSquaredError),

    /**
     * The R2 score is one of the performance evaluation measures for forecasting-based machine learning models.
     */
    R2Score(com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics.R2Score),

    /**
     * The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute Error (MAE) of (time) series with different scales.
     */
    NormalizedMeanAbsoluteError(com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics.NormalizedMeanAbsoluteError),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.RegressionPrimaryMetrics): RegressionPrimaryMetrics =
            RegressionPrimaryMetrics.values().first { it.javaValue == javaType }
    }
}
