@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
 */
public enum class RemoteLoginPortPublicAccess(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess> {
    Enabled(com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess.Enabled),
    Disabled(com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess.Disabled),
    NotSpecified(com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess.NotSpecified),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.RemoteLoginPortPublicAccess): RemoteLoginPortPublicAccess =
            RemoteLoginPortPublicAccess.values().first { it.javaValue == javaType }
    }
}
