@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of optimizer.
 */
public enum class StochasticOptimizer(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer> {
    /**
     * No optimizer selected.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer.None),

    /**
     * Stochastic Gradient Descent optimizer.
     */
    Sgd(com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer.Sgd),

    /**
     * Adam is algorithm the optimizes stochastic objective functions based on adaptive estimates of moments
     */
    Adam(com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer.Adam),

    /**
     * AdamW is a variant of the optimizer Adam that has an improved implementation of weight decay.
     */
    Adamw(com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer.Adamw),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.StochasticOptimizer): StochasticOptimizer = StochasticOptimizer.values().first { it.javaValue == javaType }
    }
}
