@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The function to be used to aggregate the time series target column to conform to a user specified frequency.
 * If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
 */
public enum class TargetAggregationFunction(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction> {
    /**
     * Represent no value set.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction.None),
    Sum(com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction.Sum),
    Max(com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction.Max),
    Min(com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction.Min),
    Mean(com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction.Mean),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.TargetAggregationFunction): TargetAggregationFunction =
            TargetAggregationFunction.values().first { it.javaValue == javaType }
    }
}
