@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Configure STL Decomposition of the time-series target column.
 */
public enum class UseStl(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.UseStl,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.UseStl> {
    /**
     * No stl decomposition.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.UseStl.None),
    Season(com.pulumi.azurenative.machinelearningservices.enums.UseStl.Season),
    SeasonTrend(com.pulumi.azurenative.machinelearningservices.enums.UseStl.SeasonTrend),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.UseStl = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.UseStl): UseStl = UseStl.values().first { it.javaValue == javaType }
    }
}
