@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Metric computation method to use for validation metrics.
 */
public enum class ValidationMetricType(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType> {
    /**
     * No metric.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType.None),

    /**
     * Coco metric.
     */
    Coco(com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType.Coco),

    /**
     * Voc metric.
     */
    Voc(com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType.Voc),

    /**
     * CocoVoc metric.
     */
    CocoVoc(com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType.CocoVoc),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ValidationMetricType): ValidationMetricType = ValidationMetricType.values().first { it.javaValue == javaType }
    }
}
