@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Account key datastore credentials configuration.
 * @property credentialsType Enum to determine the datastore credentials type.
 * Expected value is 'AccountKey'.
 * @property secrets [Required] Storage account secrets.
 */
public data class AccountKeyDatastoreCredentialsArgs(
    public val credentialsType: Output<String>,
    public val secrets: Output<AccountKeyDatastoreSecretsArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreCredentialsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreCredentialsArgs.builder()
            .credentialsType(credentialsType.applyValue({ args0 -> args0 }))
            .secrets(secrets.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AccountKeyDatastoreCredentialsArgs].
 */
@PulumiTagMarker
public class AccountKeyDatastoreCredentialsArgsBuilder internal constructor() {
    private var credentialsType: Output<String>? = null

    private var secrets: Output<AccountKeyDatastoreSecretsArgs>? = null

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'AccountKey'.
     */
    @JvmName("mjhaqkyhlkgdycvy")
    public suspend fun credentialsType(`value`: Output<String>) {
        this.credentialsType = value
    }

    /**
     * @param value [Required] Storage account secrets.
     */
    @JvmName("hjbelawdsqqranvs")
    public suspend fun secrets(`value`: Output<AccountKeyDatastoreSecretsArgs>) {
        this.secrets = value
    }

    /**
     * @param value Enum to determine the datastore credentials type.
     * Expected value is 'AccountKey'.
     */
    @JvmName("lolwbfnxifsjpwgp")
    public suspend fun credentialsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsType = mapped
    }

    /**
     * @param value [Required] Storage account secrets.
     */
    @JvmName("meelbiqlxikpwuuv")
    public suspend fun secrets(`value`: AccountKeyDatastoreSecretsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument [Required] Storage account secrets.
     */
    @JvmName("gaqsygrpeteeeple")
    public suspend fun secrets(argument: suspend AccountKeyDatastoreSecretsArgsBuilder.() -> Unit) {
        val toBeMapped = AccountKeyDatastoreSecretsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    internal fun build(): AccountKeyDatastoreCredentialsArgs = AccountKeyDatastoreCredentialsArgs(
        credentialsType = credentialsType ?: throw PulumiNullFieldException("credentialsType"),
        secrets = secrets ?: throw PulumiNullFieldException("secrets"),
    )
}
