@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoScalePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auto scale properties
 * @property enabled
 * @property maxNodeCount
 * @property minNodeCount
 */
public data class AutoScalePropertiesArgs(
    public val enabled: Output<Boolean>? = null,
    public val maxNodeCount: Output<Int>? = null,
    public val minNodeCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoScalePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AutoScalePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoScalePropertiesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .maxNodeCount(maxNodeCount?.applyValue({ args0 -> args0 }))
            .minNodeCount(minNodeCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoScalePropertiesArgs].
 */
@PulumiTagMarker
public class AutoScalePropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var maxNodeCount: Output<Int>? = null

    private var minNodeCount: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("lphqgdyjxxxpfnly")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("gvsrvwkprajxbflc")
    public suspend fun maxNodeCount(`value`: Output<Int>) {
        this.maxNodeCount = value
    }

    /**
     * @param value
     */
    @JvmName("dipyqetnpxwidxii")
    public suspend fun minNodeCount(`value`: Output<Int>) {
        this.minNodeCount = value
    }

    /**
     * @param value
     */
    @JvmName("gikseipvgklnvjga")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvisrkpwsejiqsuu")
    public suspend fun maxNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxNodeCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("takgtwlhsemvqbgm")
    public suspend fun minNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minNodeCount = mapped
    }

    internal fun build(): AutoScalePropertiesArgs = AutoScalePropertiesArgs(
        enabled = enabled,
        maxNodeCount = maxNodeCount,
        minNodeCount = minNodeCount,
    )
}
