@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoSeasonalityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Forecasting seasonality mode.
 * Expected value is 'Auto'.
 */
public data class AutoSeasonalityArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoSeasonalityArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AutoSeasonalityArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoSeasonalityArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoSeasonalityArgs].
 */
@PulumiTagMarker
public class AutoSeasonalityArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Forecasting seasonality mode.
     * Expected value is 'Auto'.
     */
    @JvmName("yvlnvtalsxlpkfjh")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Forecasting seasonality mode.
     * Expected value is 'Auto'.
     */
    @JvmName("hkgonlelirdyhmwj")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AutoSeasonalityArgs = AutoSeasonalityArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
