@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BayesianSamplingAlgorithmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a Sampling Algorithm that generates values based on previous values
 * @property samplingAlgorithmType
 * Expected value is 'Bayesian'.
 */
public data class BayesianSamplingAlgorithmArgs(
    public val samplingAlgorithmType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BayesianSamplingAlgorithmArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BayesianSamplingAlgorithmArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BayesianSamplingAlgorithmArgs.builder()
            .samplingAlgorithmType(samplingAlgorithmType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BayesianSamplingAlgorithmArgs].
 */
@PulumiTagMarker
public class BayesianSamplingAlgorithmArgsBuilder internal constructor() {
    private var samplingAlgorithmType: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Bayesian'.
     */
    @JvmName("xbeqraxlmpbtvdeu")
    public suspend fun samplingAlgorithmType(`value`: Output<String>) {
        this.samplingAlgorithmType = value
    }

    /**
     * @param value
     * Expected value is 'Bayesian'.
     */
    @JvmName("ixycxpaphlqjryhd")
    public suspend fun samplingAlgorithmType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingAlgorithmType = mapped
    }

    internal fun build(): BayesianSamplingAlgorithmArgs = BayesianSamplingAlgorithmArgs(
        samplingAlgorithmType = samplingAlgorithmType ?: throw
            PulumiNullFieldException("samplingAlgorithmType"),
    )
}
