@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BindOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the bind options for the container
 * @property createHostPath Indicate whether to create host path.
 * @property propagation Type of Bind Option
 * @property selinux Mention the selinux options.
 */
public data class BindOptionsArgs(
    public val createHostPath: Output<Boolean>? = null,
    public val propagation: Output<String>? = null,
    public val selinux: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BindOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BindOptionsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BindOptionsArgs.builder()
            .createHostPath(createHostPath?.applyValue({ args0 -> args0 }))
            .propagation(propagation?.applyValue({ args0 -> args0 }))
            .selinux(selinux?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindOptionsArgs].
 */
@PulumiTagMarker
public class BindOptionsArgsBuilder internal constructor() {
    private var createHostPath: Output<Boolean>? = null

    private var propagation: Output<String>? = null

    private var selinux: Output<String>? = null

    /**
     * @param value Indicate whether to create host path.
     */
    @JvmName("wtqynktljbrllpnr")
    public suspend fun createHostPath(`value`: Output<Boolean>) {
        this.createHostPath = value
    }

    /**
     * @param value Type of Bind Option
     */
    @JvmName("hkrbvocqegpgbmlo")
    public suspend fun propagation(`value`: Output<String>) {
        this.propagation = value
    }

    /**
     * @param value Mention the selinux options.
     */
    @JvmName("nloqcfcfyyvyxyru")
    public suspend fun selinux(`value`: Output<String>) {
        this.selinux = value
    }

    /**
     * @param value Indicate whether to create host path.
     */
    @JvmName("lbfoctqbstibvdvo")
    public suspend fun createHostPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createHostPath = mapped
    }

    /**
     * @param value Type of Bind Option
     */
    @JvmName("lagymhxuormqadrs")
    public suspend fun propagation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagation = mapped
    }

    /**
     * @param value Mention the selinux options.
     */
    @JvmName("ihdtplgnddjoesyu")
    public suspend fun selinux(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selinux = mapped
    }

    internal fun build(): BindOptionsArgs = BindOptionsArgs(
        createHostPath = createHostPath,
        propagation = propagation,
        selinux = selinux,
    )
}
