@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreSecretsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datastore certificate secrets.
 * @property certificate Service principal certificate.
 * @property secretsType Enum to determine the datastore secrets type.
 * Expected value is 'Certificate'.
 */
public data class CertificateDatastoreSecretsArgs(
    public val certificate: Output<String>? = null,
    public val secretsType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreSecretsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreSecretsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CertificateDatastoreSecretsArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .secretsType(secretsType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateDatastoreSecretsArgs].
 */
@PulumiTagMarker
public class CertificateDatastoreSecretsArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var secretsType: Output<String>? = null

    /**
     * @param value Service principal certificate.
     */
    @JvmName("apclcewenfkekkqn")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'Certificate'.
     */
    @JvmName("xggmtkwijhwkuqcs")
    public suspend fun secretsType(`value`: Output<String>) {
        this.secretsType = value
    }

    /**
     * @param value Service principal certificate.
     */
    @JvmName("qsvudqugiuntacom")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'Certificate'.
     */
    @JvmName("hmijokfrfjxifkpb")
    public suspend fun secretsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsType = mapped
    }

    internal fun build(): CertificateDatastoreSecretsArgs = CertificateDatastoreSecretsArgs(
        certificate = certificate,
        secretsType = secretsType ?: throw PulumiNullFieldException("secretsType"),
    )
}
