@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CodeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration for a scoring code asset.
 * @property codeId ARM resource ID of the code asset.
 * @property scoringScript [Required] The script to execute on startup. eg. "score.py"
 */
public data class CodeConfigurationArgs(
    public val codeId: Output<String>? = null,
    public val scoringScript: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CodeConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CodeConfigurationArgs = com.pulumi.azurenative.machinelearningservices.inputs.CodeConfigurationArgs.builder()
        .codeId(codeId?.applyValue({ args0 -> args0 }))
        .scoringScript(scoringScript.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CodeConfigurationArgs].
 */
@PulumiTagMarker
public class CodeConfigurationArgsBuilder internal constructor() {
    private var codeId: Output<String>? = null

    private var scoringScript: Output<String>? = null

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("uayvfogqqyhqcuyf")
    public suspend fun codeId(`value`: Output<String>) {
        this.codeId = value
    }

    /**
     * @param value [Required] The script to execute on startup. eg. "score.py"
     */
    @JvmName("smiaagoqpvcjreqa")
    public suspend fun scoringScript(`value`: Output<String>) {
        this.scoringScript = value
    }

    /**
     * @param value ARM resource ID of the code asset.
     */
    @JvmName("cjgdwtdksyxghxxr")
    public suspend fun codeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeId = mapped
    }

    /**
     * @param value [Required] The script to execute on startup. eg. "score.py"
     */
    @JvmName("wptssbkudtefmlcr")
    public suspend fun scoringScript(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scoringScript = mapped
    }

    internal fun build(): CodeConfigurationArgs = CodeConfigurationArgs(
        codeId = codeId,
        scoringScript = scoringScript ?: throw PulumiNullFieldException("scoringScript"),
    )
}
