@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CommandJobLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Command Job limit class.
 * @property jobLimitsType
 * Expected value is 'Command'.
 * @property timeout The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
 */
public data class CommandJobLimitsArgs(
    public val jobLimitsType: Output<String>,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CommandJobLimitsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CommandJobLimitsArgs = com.pulumi.azurenative.machinelearningservices.inputs.CommandJobLimitsArgs.builder()
        .jobLimitsType(jobLimitsType.applyValue({ args0 -> args0 }))
        .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommandJobLimitsArgs].
 */
@PulumiTagMarker
public class CommandJobLimitsArgsBuilder internal constructor() {
    private var jobLimitsType: Output<String>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value
     * Expected value is 'Command'.
     */
    @JvmName("mrlopettqnolhjbu")
    public suspend fun jobLimitsType(`value`: Output<String>) {
        this.jobLimitsType = value
    }

    /**
     * @param value The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
     */
    @JvmName("hrxwosgmuidroppd")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value
     * Expected value is 'Command'.
     */
    @JvmName("enxanxjmabvnemgn")
    public suspend fun jobLimitsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobLimitsType = mapped
    }

    /**
     * @param value The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
     */
    @JvmName("moneejwmxwflfmad")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): CommandJobLimitsArgs = CommandJobLimitsArgs(
        jobLimitsType = jobLimitsType ?: throw PulumiNullFieldException("jobLimitsType"),
        timeout = timeout,
    )
}
