@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of a component version: defines resources that span component types.
 * @property componentSpec Defines Component definition details.
 * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
 * @property description The asset description text.
 * @property isAnonymous If the name version are system generated (anonymous registration).
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class ComponentVersionArgs(
    public val componentSpec: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val isAnonymous: Output<Boolean>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs = com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs.builder()
        .componentSpec(componentSpec?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .isAnonymous(isAnonymous?.applyValue({ args0 -> args0 }))
        .isArchived(isArchived?.applyValue({ args0 -> args0 }))
        .properties(
            properties?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ComponentVersionArgs].
 */
@PulumiTagMarker
public class ComponentVersionArgsBuilder internal constructor() {
    private var componentSpec: Output<Any>? = null

    private var description: Output<String>? = null

    private var isAnonymous: Output<Boolean>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines Component definition details.
     * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
     */
    @JvmName("rvuesomxkxskxqil")
    public suspend fun componentSpec(`value`: Output<Any>) {
        this.componentSpec = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("kqsxcngxllynrlfw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("jkinwgsfsiwkdpdx")
    public suspend fun isAnonymous(`value`: Output<Boolean>) {
        this.isAnonymous = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("uftquecchpashiqv")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("aikmiauycepxsrwv")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ofsnoxdptnxkgmnr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines Component definition details.
     * <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
     */
    @JvmName("vimegnobinxuneoc")
    public suspend fun componentSpec(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentSpec = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("kqudniydbgeptqoq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If the name version are system generated (anonymous registration).
     */
    @JvmName("dlwtlpaboxflvoxd")
    public suspend fun isAnonymous(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAnonymous = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("vbphbnnhtnpdceot")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("rbdhxtayxaoxfrgh")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("ggjfpygmblofdrvv")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jipjfbupgjcbmjyt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("iapynqtawntjwsce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ComponentVersionArgs = ComponentVersionArgs(
        componentSpec = componentSpec,
        description = description,
        isAnonymous = isAnonymous,
        isArchived = isArchived,
        properties = properties,
        tags = tags,
    )
}
