@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu Number of vCPUs request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 * @property gpu Number of Nvidia GPU cards request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 * @property memory Memory size request/limit for container. More info:
 * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 */
public data class ContainerResourceSettingsArgs(
    public val cpu: Output<String>? = null,
    public val gpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ContainerResourceSettingsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerResourceSettingsArgs].
 */
@PulumiTagMarker
public class ContainerResourceSettingsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var gpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Number of vCPUs request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("ssdorugpirjvdjif")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Number of Nvidia GPU cards request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("rgxwrcekjsleqlip")
    public suspend fun gpu(`value`: Output<String>) {
        this.gpu = value
    }

    /**
     * @param value Memory size request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("tpleiorexwxdqsuc")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Number of vCPUs request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("qieunfqyyxgajsjd")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Number of Nvidia GPU cards request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("vsrnutcmqiqybkgn")
    public suspend fun gpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value Memory size request/limit for container. More info:
     * https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     */
    @JvmName("grqqrkrxtxiwtvyy")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ContainerResourceSettingsArgs = ContainerResourceSettingsArgs(
        cpu = cpu,
        gpu = gpu,
        memory = memory,
    )
}
