@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CronTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTime Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
 * Recommented format would be "2022-06-01T00:00:01"
 * If not present, the schedule will run indefinitely
 * @property expression [Required] Specifies cron expression of schedule.
 * The expression should follow NCronTab format.
 * @property startTime Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 * @property triggerType
 * Expected value is 'Cron'.
 */
public data class CronTriggerArgs(
    public val endTime: Output<String>? = null,
    public val expression: Output<String>,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
    public val triggerType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CronTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CronTriggerArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CronTriggerArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .triggerType(triggerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CronTriggerArgs].
 */
@PulumiTagMarker
public class CronTriggerArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var expression: Output<String>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    private var triggerType: Output<String>? = null

    /**
     * @param value Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
     * Recommented format would be "2022-06-01T00:00:01"
     * If not present, the schedule will run indefinitely
     */
    @JvmName("vehuwigsbvwikhvq")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value [Required] Specifies cron expression of schedule.
     * The expression should follow NCronTab format.
     */
    @JvmName("jrcpsnarqmyyabmj")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
     */
    @JvmName("jwgwjscdqhdwkdik")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("ignjqjnfxxoysdag")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value
     * Expected value is 'Cron'.
     */
    @JvmName("ycchnpvrrnejlhlj")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
     * Recommented format would be "2022-06-01T00:00:01"
     * If not present, the schedule will run indefinitely
     */
    @JvmName("llgoqhlshjurvjes")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value [Required] Specifies cron expression of schedule.
     * The expression should follow NCronTab format.
     */
    @JvmName("gfhkunwpxqmybovn")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
     */
    @JvmName("mjxmnwdaxenbjybt")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Specifies time zone in which the schedule runs.
     * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
     */
    @JvmName("fugsyxpailpfbdym")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value
     * Expected value is 'Cron'.
     */
    @JvmName("facsavffgdptcljw")
    public suspend fun triggerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): CronTriggerArgs = CronTriggerArgs(
        endTime = endTime,
        expression = expression ?: throw PulumiNullFieldException("expression"),
        startTime = startTime,
        timeZone = timeZone,
        triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
    )
}
