@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CustomNCrossValidationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * N-Cross validations are specified by user.
 * @property mode Determines how N-Cross validations value is determined.
 * Expected value is 'Custom'.
 * @property value [Required] N-Cross validations value.
 */
public data class CustomNCrossValidationsArgs(
    public val mode: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CustomNCrossValidationsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CustomNCrossValidationsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CustomNCrossValidationsArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomNCrossValidationsArgs].
 */
@PulumiTagMarker
public class CustomNCrossValidationsArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Determines how N-Cross validations value is determined.
     * Expected value is 'Custom'.
     */
    @JvmName("vllnhmmpfafgyphf")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value [Required] N-Cross validations value.
     */
    @JvmName("chhmynpgpnnjlpjs")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Determines how N-Cross validations value is determined.
     * Expected value is 'Custom'.
     */
    @JvmName("nmxsxvmuooogekst")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value [Required] N-Cross validations value.
     */
    @JvmName("uiekxlpgensnjpxm")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CustomNCrossValidationsArgs = CustomNCrossValidationsArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
