@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CustomServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies the custom service configuration
 * @property docker Describes the docker settings for the image
 * @property endpoints Configuring the endpoints for the container
 * @property environmentVariables Environment Variable for the container
 * @property image Describes the Image Specifications
 * @property name Name of the Custom Service
 * @property volumes Configuring the volumes for the container
 */
public data class CustomServiceArgs(
    public val docker: Output<DockerArgs>? = null,
    public val endpoints: Output<List<EndpointArgs>>? = null,
    public val environmentVariables: Output<Map<String, EnvironmentVariableArgs>>? = null,
    public val image: Output<ImageArgs>? = null,
    public val name: Output<String>? = null,
    public val volumes: Output<List<VolumeDefinitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CustomServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CustomServiceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CustomServiceArgs.builder()
            .docker(docker?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomServiceArgs].
 */
@PulumiTagMarker
public class CustomServiceArgsBuilder internal constructor() {
    private var docker: Output<DockerArgs>? = null

    private var endpoints: Output<List<EndpointArgs>>? = null

    private var environmentVariables: Output<Map<String, EnvironmentVariableArgs>>? = null

    private var image: Output<ImageArgs>? = null

    private var name: Output<String>? = null

    private var volumes: Output<List<VolumeDefinitionArgs>>? = null

    /**
     * @param value Describes the docker settings for the image
     */
    @JvmName("horneoowwfydxvac")
    public suspend fun docker(`value`: Output<DockerArgs>) {
        this.docker = value
    }

    /**
     * @param value Configuring the endpoints for the container
     */
    @JvmName("rsaislvdxuewstjm")
    public suspend fun endpoints(`value`: Output<List<EndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("qrmyphbsxovqlibr")
    public suspend fun endpoints(vararg values: Output<EndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values Configuring the endpoints for the container
     */
    @JvmName("kkemhpalxbkuemme")
    public suspend fun endpoints(values: List<Output<EndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Environment Variable for the container
     */
    @JvmName("llhjomcipkpivulm")
    public suspend fun environmentVariables(`value`: Output<Map<String, EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Describes the Image Specifications
     */
    @JvmName("nmuhwuvtobrisoiq")
    public suspend fun image(`value`: Output<ImageArgs>) {
        this.image = value
    }

    /**
     * @param value Name of the Custom Service
     */
    @JvmName("smirujpjadfjqrfr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuring the volumes for the container
     */
    @JvmName("rpndigvchtebkaif")
    public suspend fun volumes(`value`: Output<List<VolumeDefinitionArgs>>) {
        this.volumes = value
    }

    @JvmName("jjibnnmscnrgixds")
    public suspend fun volumes(vararg values: Output<VolumeDefinitionArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values Configuring the volumes for the container
     */
    @JvmName("pwofddqwjlqiewar")
    public suspend fun volumes(values: List<Output<VolumeDefinitionArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value Describes the docker settings for the image
     */
    @JvmName("jjtjuitvyxnwfomb")
    public suspend fun docker(`value`: DockerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docker = mapped
    }

    /**
     * @param argument Describes the docker settings for the image
     */
    @JvmName("wptwusdjdlxtttup")
    public suspend fun docker(argument: suspend DockerArgsBuilder.() -> Unit) {
        val toBeMapped = DockerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.docker = mapped
    }

    /**
     * @param value Configuring the endpoints for the container
     */
    @JvmName("nsbrwclexctrtona")
    public suspend fun endpoints(`value`: List<EndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument Configuring the endpoints for the container
     */
    @JvmName("jwdnhpmmwnusvwgx")
    public suspend fun endpoints(argument: List<suspend EndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EndpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Configuring the endpoints for the container
     */
    @JvmName("ebpipcsunpaadeov")
    public suspend fun endpoints(vararg argument: suspend EndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EndpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument Configuring the endpoints for the container
     */
    @JvmName("dflhbtkkmqoychki")
    public suspend fun endpoints(argument: suspend EndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values Configuring the endpoints for the container
     */
    @JvmName("qgaatuoryxtqdoid")
    public suspend fun endpoints(vararg values: EndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value Environment Variable for the container
     */
    @JvmName("qhbgnpoqmernigwt")
    public suspend fun environmentVariables(`value`: Map<String, EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument Environment Variable for the container
     */
    @JvmName("ahdgekxumjggxuff")
    public suspend fun environmentVariables(vararg argument: Pair<String, suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                EnvironmentVariableArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment Variable for the container
     */
    @JvmName("mjojvivxtkegtsjp")
    public fun environmentVariables(vararg values: Pair<String, EnvironmentVariableArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Describes the Image Specifications
     */
    @JvmName("gsjhmccqqnonmvla")
    public suspend fun image(`value`: ImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument Describes the Image Specifications
     */
    @JvmName("jahiipvfgqdgtrxs")
    public suspend fun image(argument: suspend ImageArgsBuilder.() -> Unit) {
        val toBeMapped = ImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value Name of the Custom Service
     */
    @JvmName("kdygqcowseynggkr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuring the volumes for the container
     */
    @JvmName("nkyiksdimwnpyakk")
    public suspend fun volumes(`value`: List<VolumeDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument Configuring the volumes for the container
     */
    @JvmName("ipkvygqjjerioxle")
    public suspend fun volumes(argument: List<suspend VolumeDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VolumeDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Configuring the volumes for the container
     */
    @JvmName("krebwwhmgalixxfm")
    public suspend fun volumes(vararg argument: suspend VolumeDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VolumeDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument Configuring the volumes for the container
     */
    @JvmName("tjgluiytnlrevkcp")
    public suspend fun volumes(argument: suspend VolumeDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values Configuring the volumes for the container
     */
    @JvmName("dnvneoieewjgusdo")
    public suspend fun volumes(vararg values: VolumeDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): CustomServiceArgs = CustomServiceArgs(
        docker = docker,
        endpoints = endpoints,
        environmentVariables = environmentVariables,
        image = image,
        name = name,
        volumes = volumes,
    )
}
