@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetRollingWindowSizeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Target rolling windows size mode.
 * Expected value is 'Custom'.
 * @property value [Required] TargetRollingWindowSize value.
 */
public data class CustomTargetRollingWindowSizeArgs(
    public val mode: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetRollingWindowSizeArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetRollingWindowSizeArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetRollingWindowSizeArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomTargetRollingWindowSizeArgs].
 */
@PulumiTagMarker
public class CustomTargetRollingWindowSizeArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Target rolling windows size mode.
     * Expected value is 'Custom'.
     */
    @JvmName("dlctbkcbionlnqin")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value [Required] TargetRollingWindowSize value.
     */
    @JvmName("okudiwsjxodyvsgl")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Target rolling windows size mode.
     * Expected value is 'Custom'.
     */
    @JvmName("mwvaunocfykearew")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value [Required] TargetRollingWindowSize value.
     */
    @JvmName("kshvqppgcjwijrbq")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CustomTargetRollingWindowSizeArgs = CustomTargetRollingWindowSizeArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
