@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.DataType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container for data asset versions.
 * @property dataType [Required] Specifies the type of data.
 * @property description The asset description text.
 * @property isArchived Is the asset archived?
 * @property properties The asset property dictionary.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class DataContainerArgs(
    public val dataType: Output<Either<String, DataType>>,
    public val description: Output<String>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs.builder()
            .dataType(
                dataType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataContainerArgs].
 */
@PulumiTagMarker
public class DataContainerArgsBuilder internal constructor() {
    private var dataType: Output<Either<String, DataType>>? = null

    private var description: Output<String>? = null

    private var isArchived: Output<Boolean>? = null

    private var properties: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Specifies the type of data.
     */
    @JvmName("hvffkuxkwjmehcjn")
    public suspend fun dataType(`value`: Output<Either<String, DataType>>) {
        this.dataType = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("smtlsosgjadttknl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("cykgmdjtwryevjdy")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("skrluwhjoqgxqsmp")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("vgijmkpbsusqhvbv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Specifies the type of data.
     */
    @JvmName("lmiiqtnlavauqsde")
    public suspend fun dataType(`value`: Either<String, DataType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value [Required] Specifies the type of data.
     */
    @JvmName("usvkemfquowggnfb")
    public fun dataType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value [Required] Specifies the type of data.
     */
    @JvmName("pnuojblfbklrxfti")
    public fun dataType(`value`: DataType) {
        val toBeMapped = Either.ofRight<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("mwkmudbtqmytkoyv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("xmkycsxxhbrgybay")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("ayeaefgvlflwxonq")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("fvdoqikfhvakpolj")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ajaxqdxidfsyeqec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("iearnxjwsdixdsxc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataContainerArgs = DataContainerArgs(
        dataType = dataType ?: throw PulumiNullFieldException("dataType"),
        description = description,
        isArchived = isArchived,
        properties = properties,
        tags = tags,
    )
}
