@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DockerImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class to represent configuration settings for Docker Build
 * @property dockerImageUri [Required] Image name of a custom base image.
 * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
 * @property dockerSpecificationType Enum to determine docker specification type. Must be either Build or Image.
 * Expected value is 'Image'.
 * @property platform The platform information of the docker image.
 */
public data class DockerImageArgs(
    public val dockerImageUri: Output<String>,
    public val dockerSpecificationType: Output<String>,
    public val platform: Output<DockerImagePlatformArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DockerImageArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.DockerImageArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DockerImageArgs.builder()
            .dockerImageUri(dockerImageUri.applyValue({ args0 -> args0 }))
            .dockerSpecificationType(dockerSpecificationType.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DockerImageArgs].
 */
@PulumiTagMarker
public class DockerImageArgsBuilder internal constructor() {
    private var dockerImageUri: Output<String>? = null

    private var dockerSpecificationType: Output<String>? = null

    private var platform: Output<DockerImagePlatformArgs>? = null

    /**
     * @param value [Required] Image name of a custom base image.
     * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
     */
    @JvmName("yywxrbugvkptydbg")
    public suspend fun dockerImageUri(`value`: Output<String>) {
        this.dockerImageUri = value
    }

    /**
     * @param value Enum to determine docker specification type. Must be either Build or Image.
     * Expected value is 'Image'.
     */
    @JvmName("tewibjqulgwadnyk")
    public suspend fun dockerSpecificationType(`value`: Output<String>) {
        this.dockerSpecificationType = value
    }

    /**
     * @param value The platform information of the docker image.
     */
    @JvmName("pxlatytrymjdkadk")
    public suspend fun platform(`value`: Output<DockerImagePlatformArgs>) {
        this.platform = value
    }

    /**
     * @param value [Required] Image name of a custom base image.
     * <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
     */
    @JvmName("fkwgptpbfmotnucy")
    public suspend fun dockerImageUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerImageUri = mapped
    }

    /**
     * @param value Enum to determine docker specification type. Must be either Build or Image.
     * Expected value is 'Image'.
     */
    @JvmName("tmutbmqwyawxulqq")
    public suspend fun dockerSpecificationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerSpecificationType = mapped
    }

    /**
     * @param value The platform information of the docker image.
     */
    @JvmName("bjsjnvvcmjdxrrin")
    public suspend fun platform(`value`: DockerImagePlatformArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform information of the docker image.
     */
    @JvmName("mxgknpupixyguvwo")
    public suspend fun platform(argument: suspend DockerImagePlatformArgsBuilder.() -> Unit) {
        val toBeMapped = DockerImagePlatformArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    internal fun build(): DockerImageArgs = DockerImageArgs(
        dockerImageUri = dockerImageUri ?: throw PulumiNullFieldException("dockerImageUri"),
        dockerSpecificationType = dockerSpecificationType ?: throw
            PulumiNullFieldException("dockerSpecificationType"),
        platform = platform,
    )
}
