@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EncryptionKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identityClientId For future use - The client id of the identity which will be used to access key vault.
 * @property keyIdentifier Key vault uri to access the encryption key.
 * @property keyVaultArmId The ArmId of the keyVault where the customer owned encryption key is present.
 */
public data class EncryptionKeyVaultPropertiesArgs(
    public val identityClientId: Output<String>? = null,
    public val keyIdentifier: Output<String>,
    public val keyVaultArmId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EncryptionKeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.EncryptionKeyVaultPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EncryptionKeyVaultPropertiesArgs.builder()
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .keyIdentifier(keyIdentifier.applyValue({ args0 -> args0 }))
            .keyVaultArmId(keyVaultArmId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionKeyVaultPropertiesArgsBuilder internal constructor() {
    private var identityClientId: Output<String>? = null

    private var keyIdentifier: Output<String>? = null

    private var keyVaultArmId: Output<String>? = null

    /**
     * @param value For future use - The client id of the identity which will be used to access key vault.
     */
    @JvmName("jhdwevsnrddhogax")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value Key vault uri to access the encryption key.
     */
    @JvmName("bwkkrytohygusnqx")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The ArmId of the keyVault where the customer owned encryption key is present.
     */
    @JvmName("ppiftybgisebnfhu")
    public suspend fun keyVaultArmId(`value`: Output<String>) {
        this.keyVaultArmId = value
    }

    /**
     * @param value For future use - The client id of the identity which will be used to access key vault.
     */
    @JvmName("snyarhdcmpmgwgte")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value Key vault uri to access the encryption key.
     */
    @JvmName("fwilrrfumlcixrkm")
    public suspend fun keyIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    /**
     * @param value The ArmId of the keyVault where the customer owned encryption key is present.
     */
    @JvmName("bjqagjjimdfkagpg")
    public suspend fun keyVaultArmId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultArmId = mapped
    }

    internal fun build(): EncryptionKeyVaultPropertiesArgs = EncryptionKeyVaultPropertiesArgs(
        identityClientId = identityClientId,
        keyIdentifier = keyIdentifier ?: throw PulumiNullFieldException("keyIdentifier"),
        keyVaultArmId = keyVaultArmId ?: throw PulumiNullFieldException("keyVaultArmId"),
    )
}
