@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dto object representing specification
 * @property path Specifies the spec path
 */
public data class FeaturesetSpecificationArgs(
    public val path: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetSpecificationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.FeaturesetSpecificationArgs.builder()
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeaturesetSpecificationArgs].
 */
@PulumiTagMarker
public class FeaturesetSpecificationArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    /**
     * @param value Specifies the spec path
     */
    @JvmName("vpfepmtyvprewrbt")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Specifies the spec path
     */
    @JvmName("vxsqfdemjnayplhy")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): FeaturesetSpecificationArgs = FeaturesetSpecificationArgs(
        path = path,
    )
}
