@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetCapacityReservationGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCapacityReservationGroupPlainArgs(
    public val groupId: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetCapacityReservationGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetCapacityReservationGroupPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetCapacityReservationGroupPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapacityReservationGroupPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityReservationGroupPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value
     */
    @JvmName("xcrhidlpfusoxhph")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ejlavspcxpisnjjk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCapacityReservationGroupPlainArgs = GetCapacityReservationGroupPlainArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
