@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Friendly name of the workspace connection
 * @property deploymentName Name of the deployment resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class GetConnectionDeploymentPlainArgs(
    public val connectionName: String,
    public val deploymentName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionDeploymentPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionDeploymentPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionDeploymentPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var deploymentName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("eqoygoqfddqeabph")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value Name of the deployment resource
     */
    @JvmName("xiqmvqfidchvilvj")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lhuksvgytqlssdcw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("rpdsaeehdxuynuxt")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetConnectionDeploymentPlainArgs = GetConnectionDeploymentPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
