@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiBlocklistItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Friendly name of the workspace connection
 * @property raiBlocklistName The name of the RaiBlocklist.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class GetConnectionRaiBlocklistItemPlainArgs(
    public val connectionName: String,
    public val raiBlocklistName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiBlocklistItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiBlocklistItemPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiBlocklistItemPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .raiBlocklistName(raiBlocklistName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionRaiBlocklistItemPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionRaiBlocklistItemPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var raiBlocklistName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("xpejddegmnwcwods")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist.
     */
    @JvmName("vwooymxcupclvdbt")
    public suspend fun raiBlocklistName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggwnioygqoppyewb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("ojklfmbcjjcwwpks")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetConnectionRaiBlocklistItemPlainArgs =
        GetConnectionRaiBlocklistItemPlainArgs(
            connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
            raiBlocklistName = raiBlocklistName ?: throw PulumiNullFieldException("raiBlocklistName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
