@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Friendly name of the workspace connection
 * @property raiPolicyName Name of the Rai Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class GetConnectionRaiPolicyPlainArgs(
    public val connectionName: String,
    public val raiPolicyName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiPolicyPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetConnectionRaiPolicyPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .raiPolicyName(raiPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionRaiPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionRaiPolicyPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var raiPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Friendly name of the workspace connection
     */
    @JvmName("eruxgfvbnsjpxyhc")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value Name of the Rai Policy.
     */
    @JvmName("fufwtsdbakuwxidb")
    public suspend fun raiPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dwvayydiyqbxbsnu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("liwmbmameotshkgn")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetConnectionRaiPolicyPlainArgs = GetConnectionRaiPolicyPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        raiPolicyName = raiPolicyName ?: throw PulumiNullFieldException("raiPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
