@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturesetVersionFeaturePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property featureName Specifies name of the feature.
 * @property name Feature set name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Feature set version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetFeaturesetVersionFeaturePlainArgs(
    public val featureName: String? = null,
    public val name: String,
    public val resourceGroupName: String,
    public val version: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturesetVersionFeaturePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturesetVersionFeaturePlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetFeaturesetVersionFeaturePlainArgs.builder()
            .featureName(featureName?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFeaturesetVersionFeaturePlainArgs].
 */
@PulumiTagMarker
public class GetFeaturesetVersionFeaturePlainArgsBuilder internal constructor() {
    private var featureName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var version: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Specifies name of the feature.
     */
    @JvmName("nfoosatljfljymrj")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.featureName = mapped
    }

    /**
     * @param value Feature set name. This is case-sensitive.
     */
    @JvmName("tqkjrmqexovxrvmw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ivuxhdqwfnrqqlqw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Feature set version identifier. This is case-sensitive.
     */
    @JvmName("wbsqrovytnhmmtgn")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("mgxextcsxdkjbvmj")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetFeaturesetVersionFeaturePlainArgs = GetFeaturesetVersionFeaturePlainArgs(
        featureName = featureName,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        version = version ?: throw PulumiNullFieldException("version"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
