@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineDeploymentLogsPlainArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ContainerType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerType The type of container to retrieve logs from.
 * @property deploymentName The name and identifier for the endpoint.
 * @property endpointName Inference endpoint name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tail The maximum number of lines to tail.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetOnlineDeploymentLogsPlainArgs(
    public val containerType: Either<String, ContainerType>? = null,
    public val deploymentName: String,
    public val endpointName: String,
    public val resourceGroupName: String,
    public val tail: Int? = null,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineDeploymentLogsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineDeploymentLogsPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineDeploymentLogsPlainArgs.builder()
            .containerType(
                containerType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .endpointName(endpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tail(tail?.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOnlineDeploymentLogsPlainArgs].
 */
@PulumiTagMarker
public class GetOnlineDeploymentLogsPlainArgsBuilder internal constructor() {
    private var containerType: Either<String, ContainerType>? = null

    private var deploymentName: String? = null

    private var endpointName: String? = null

    private var resourceGroupName: String? = null

    private var tail: Int? = null

    private var workspaceName: String? = null

    /**
     * @param value The type of container to retrieve logs from.
     */
    @JvmName("epdqprikpltpviwr")
    public suspend fun containerType(`value`: Either<String, ContainerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.containerType = mapped
    }

    /**
     * @param value The type of container to retrieve logs from.
     */
    @JvmName("kylnhdbwgyjygpgg")
    public fun containerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerType = mapped
    }

    /**
     * @param value The type of container to retrieve logs from.
     */
    @JvmName("hbhpbvvhbpnouian")
    public fun containerType(`value`: ContainerType) {
        val toBeMapped = Either.ofRight<String, ContainerType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerType = mapped
    }

    /**
     * @param value The name and identifier for the endpoint.
     */
    @JvmName("qcftmbpowbxyhrgy")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value Inference endpoint name.
     */
    @JvmName("ncupmmgusdfkfids")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jdfsuvqappqmtgxm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The maximum number of lines to tail.
     */
    @JvmName("cmpxtpfnuwibfnrp")
    public suspend fun tail(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tail = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("esrsuxgoukrikfro")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetOnlineDeploymentLogsPlainArgs = GetOnlineDeploymentLogsPlainArgs(
        containerType = containerType,
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tail = tail,
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
