@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineEndpointTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName Online Endpoint name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetOnlineEndpointTokenPlainArgs(
    public val endpointName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineEndpointTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineEndpointTokenPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetOnlineEndpointTokenPlainArgs.builder()
            .endpointName(endpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOnlineEndpointTokenPlainArgs].
 */
@PulumiTagMarker
public class GetOnlineEndpointTokenPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Online Endpoint name.
     */
    @JvmName("aynhkywwiytrvets")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("otemtixffckahqfu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("dkedtbbvnrphfsam")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetOnlineEndpointTokenPlainArgs = GetOnlineEndpointTokenPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
