@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRaiPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName Name of the endpoint resource.
 * @property raiPolicyName Name of the Rai Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class GetRaiPolicyPlainArgs(
    public val endpointName: String,
    public val raiPolicyName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRaiPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetRaiPolicyPlainArgs = com.pulumi.azurenative.machinelearningservices.inputs.GetRaiPolicyPlainArgs.builder()
        .endpointName(endpointName.let({ args0 -> args0 }))
        .raiPolicyName(raiPolicyName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRaiPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetRaiPolicyPlainArgsBuilder internal constructor() {
    private var endpointName: String? = null

    private var raiPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Name of the endpoint resource.
     */
    @JvmName("oolqcpubhdceoysy")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointName = mapped
    }

    /**
     * @param value Name of the Rai Policy.
     */
    @JvmName("usnksywgnlwrumic")
    public suspend fun raiPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqmssiwveawqjiio")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("wtkvhcvqwutikggd")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetRaiPolicyPlainArgs = GetRaiPolicyPlainArgs(
        endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
        raiPolicyName = raiPolicyName ?: throw PulumiNullFieldException("raiPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
