@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRegistryComponentContainerPlainArgs(
    public val componentName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentContainerPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryComponentContainerPlainArgs.builder()
            .componentName(componentName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryComponentContainerPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryComponentContainerPlainArgsBuilder internal constructor() {
    private var componentName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Container name.
     */
    @JvmName("osxohwcxgxrnxjno")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.componentName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("yaucbjmwvimdnlpd")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rpqimqbpgobmokwn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegistryComponentContainerPlainArgs =
        GetRegistryComponentContainerPlainArgs(
            componentName = componentName ?: throw PulumiNullFieldException("componentName"),
            registryName = registryName ?: throw PulumiNullFieldException("registryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
